#version 120 

varying vec4 frontColor;
varying vec4 fogColor;
varying float fragAlpha;
varying float gamma_i;

uniform sampler2D tex0;
uniform vec2 map_siz_inv;

void main ()
{
    // get texture 1 color
    vec4 texval1 = texture2D(tex0, gl_TexCoord[0].st); 
   
    // compute lightness 
    float lig = texval1.r + texval1.g + texval1.b; 
    lig *= 0.3333333333;
   
    // apply less contrast
//	lig -= 0.5;
//	lig *= 0.44;
//	lig += 0.5;
   
    // prepare inverted alpha of vertex color
    float a_inv = 1.0 - fogColor.a;
   
    // calculate result color
    texval1.r = texval1.r * a_inv + fogColor.r * lig * fogColor.a;
    texval1.g = texval1.g * a_inv + fogColor.g * lig * fogColor.a;
    texval1.b = texval1.b * a_inv + fogColor.b * lig * fogColor.a;
    texval1.a *= fragAlpha * frontColor.a;

    if(gamma_i == 1.0)
    {
        gl_FragColor = texval1;
    }
    else
    {
        gl_FragColor = vec4( pow(texval1.rgb, vec3(gamma_i)), texval1.a);
    }
}
